import os
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

import utilities

# Open the file "./hipparcos-voidmain.csv" for reading
f = open("./hipparcos-voidmain.csv", "r")

dataset = pd.read_csv(f, sep=",", header=0)

# Get the position data
x = np.array(dataset["RAdeg"], dtype=float)
y = np.array(dataset["DEdeg"], dtype=float)

# Get the magnitude data (will be use to determine the size of the point)
apparentMag = np.array(dataset["Vmag"], dtype=float)
# Convert apparentMag to size
size = 10 ** (apparentMag / -2.5)

# Get the color data (will be use to determine the color of the point)
bmv = np.array(dataset["B-V"], dtype=float)
# Map B-V to RGB
rgb = np.array([utilities.bv2rgb(bv) for bv in bmv])

# Plot the stars position distribution
plt.scatter(x, y, s=size, c=rgb, alpha=0.75)
plt.title("Stars position")
plt.xlabel("RAdeg")
plt.ylabel("DEdeg")
plt.gca().set_facecolor('black')
plt.gca().invert_xaxis()
plt.show()

# Close the file
f.close()
