import os
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

# Open the file "./hipparcos-voidmain.csv" for reading
f = open("./hipparcos-voidmain.csv", "r")

dataset = pd.read_csv(f, sep=",", header=0)

# Get the data we want to plot
# Apparent magnitude in the V band (visible light)
apparentMag = np.array(dataset["Vmag"], dtype=float)
# B-V color index
bmv = np.array(dataset["B-V"], dtype=float)
# Paralax
paralax = np.array(dataset["Plx"].notna().notnull(), dtype=float)
paralax = paralax[paralax > 0.1]
# Compute distance only if parallax is not zero
distance = 1000 / paralax # unit: parsec
# Absolute magnitude
absoluteMag = apparentMag - 5 * np.log10(distance / 10)

# Plot the KDE of apparent magnitude, B-V color index, distance and absolute magnitude
figure, axis = plt.subplots(2, 2, figsize=(10, 10))
axis[0, 0].set_title("KDE of apparent magnitude")
axis[0, 0].set_xlabel("Apparent magnitude")
axis[0, 0].set_ylabel("Density")

axis[0, 1].set_title("KDE of B-V color index")
axis[0, 1].set_xlabel("B-V color index")
axis[0, 1].set_ylabel("Density")

axis[1, 0].set_title("KDE of distance")
axis[1, 0].set_xlabel("Distance")
axis[1, 0].set_ylabel("Density")

axis[1, 1].set_title("KDE of absolute magnitude")
axis[1, 1].set_xlabel("Absolute magnitude")
axis[1, 1].set_ylabel("Density")

axis[0, 0].hist(apparentMag, bins=100, density=True)
axis[0, 1].hist(bmv, bins=100, density=True)
axis[1, 0].hist(paralax, bins=100, density=True)
axis[1, 1].hist(absoluteMag, bins=100, density=True)

plt.show()

# Close the file
f.close()
