# Get the rgb color from B-V color
# More info: https://wikipedia.org/wiki/Color_index
# Function from https://stackoverflow.com/questions/21977786/star-b-v-color-index-to-apparent-rgb-color
# By AymericG
def bv2rgb(bv):
	if bv < -0.40: bv = -0.40
	if bv > 2.00: bv = 2.00
	r = 0.0
	g = 0.0
	b = 0.0
	if  -0.40 <= bv<0.00:
		t=(bv+0.40)/(0.00+0.40)
		r=0.61+(0.11*t)+(0.1*t*t)
	elif 0.00 <= bv<0.40:
		t=(bv-0.00)/(0.40-0.00)
		r=0.83+(0.17*t)
	elif 0.40 <= bv<2.10:
		t=(bv-0.40)/(2.10-0.40)
		r=1.00
	if  -0.40 <= bv<0.00:
		t=(bv+0.40)/(0.00+0.40)
		g=0.70+(0.07*t)+(0.1*t*t)
	elif 0.00 <= bv<0.40:
		t=(bv-0.00)/(0.40-0.00)
		g=0.87+(0.11*t)
	elif 0.40 <= bv<1.60:
		t=(bv-0.40)/(1.60-0.40)
		g=0.98-(0.16*t)
	elif 1.60 <= bv<2.00:
		t=(bv-1.60)/(2.00-1.60)
		g=0.82-(0.5*t*t)
	if  -0.40 <= bv<0.40:
		t=(bv+0.40)/(0.40+0.40)
		b=1.00
	elif 0.40 <= bv<1.50:
		t=(bv-0.40)/(1.50-0.40)
		b=1.00-(0.47*t)+(0.1*t*t)
	elif 1.50 <= bv<1.94:
		t=(bv-1.50)/(1.94-1.50)
		b=0.63-(0.6*t*t)
	return (r, g, b)

# Get the temperature from B-V color
# More info: https://wikipedia.org/wiki/Color_index
def bv2temp(bv):
	temp=4600.0*(1.0/(0.92*bv+1.7)+1.0/(0.92*bv+0.62))
	return temp