void StyleCatppuccinMocha(ImGuiStyle* dst = NULL)
{
    auto HexToImVec4 = [](const std::string& hex) {
        unsigned rgba;
        std::stringstream ss;
        ss << std::hex << hex.substr(1);
        ss >> rgba;
        ImVec4 res = {
			(float)((rgba >> 24) & 0xFF) / 255.0f,
			(float)((rgba >> 16) & 0xFF) / 255.0f,
			(float)((rgba >> 8) & 0xFF) / 255.0f,
			(float)((rgba >> 0) & 0xFF) / 255.0f
        };
        return res;
    };

    ImGuiStyle* style = dst ? dst : &ImGui::GetStyle();

    style->WindowPadding = ImVec2(15, 15);
    style->WindowRounding = 5.0f;
    style->FramePadding = ImVec2(5, 5);
    style->FrameRounding = 4.0f;
    style->ItemSpacing = ImVec2(12, 8);
    style->ItemInnerSpacing = ImVec2(8, 6);
    style->IndentSpacing = 25.0f;
    style->ScrollbarSize = 15.0f;
    style->ScrollbarRounding = 9.0f;
    style->GrabMinSize = 5.0f;
    style->GrabRounding = 3.0f;

    style->Colors[ImGuiCol_Text] = HexToImVec4("#CDD6F4FF");
    style->Colors[ImGuiCol_TextDisabled] = HexToImVec4("#7F849CFF");
    style->Colors[ImGuiCol_WindowBg] = HexToImVec4("#1e1e2eff");
    style->Colors[ImGuiCol_ChildBg] = HexToImVec4("#1e1e2eff");
    style->Colors[ImGuiCol_PopupBg] = HexToImVec4("#1e1e2eff");
    style->Colors[ImGuiCol_Border] = HexToImVec4("#A6ADC8FF");
    style->Colors[ImGuiCol_BorderShadow] = HexToImVec4("#BAC2DEFF");
    style->Colors[ImGuiCol_FrameBg] = HexToImVec4("#1e1e2eff");
    style->Colors[ImGuiCol_FrameBgHovered] = HexToImVec4("#89DCEB80");
    style->Colors[ImGuiCol_FrameBgActive] = HexToImVec4("#B4BEFEFF");
    style->Colors[ImGuiCol_TitleBg] = HexToImVec4("#181825FF");
    style->Colors[ImGuiCol_TitleBgActive] = HexToImVec4("#181825FF");
    style->Colors[ImGuiCol_TitleBgCollapsed] = HexToImVec4("#181825FF");
    style->Colors[ImGuiCol_MenuBarBg] = HexToImVec4("#1e1e2eff");
    style->Colors[ImGuiCol_ScrollbarBg] = HexToImVec4("#1e1e2eff");
    style->Colors[ImGuiCol_ScrollbarGrab] = HexToImVec4("#7F849CFF");
    style->Colors[ImGuiCol_ScrollbarGrabHovered] = HexToImVec4("#89DCEB80");
    style->Colors[ImGuiCol_ScrollbarGrabActive] = HexToImVec4("#B4BEFEFF");
    style->Colors[ImGuiCol_CheckMark] = HexToImVec4("#89B4FAFF");
    style->Colors[ImGuiCol_SliderGrab] = HexToImVec4("#6C7086FF");
    style->Colors[ImGuiCol_SliderGrabActive] = HexToImVec4("#B4BEFEFF");
    style->Colors[ImGuiCol_Button] = HexToImVec4("#89B4FA80");
    style->Colors[ImGuiCol_ButtonHovered] = HexToImVec4("#89DCEB80");
    style->Colors[ImGuiCol_ButtonActive] = HexToImVec4("#B4BEFEFF");
    style->Colors[ImGuiCol_Header] = HexToImVec4("#74C7EC80");
    style->Colors[ImGuiCol_HeaderHovered] = HexToImVec4("#89DCEB80");
    style->Colors[ImGuiCol_HeaderActive] = HexToImVec4("#B4BEFE80");
    style->Colors[ImGuiCol_Separator] = style->Colors[ImGuiCol_Border];
    style->Colors[ImGuiCol_SeparatorHovered] = HexToImVec4("#89DCEB80");
    style->Colors[ImGuiCol_SeparatorActive] = HexToImVec4("#B4BEFEFF");
    style->Colors[ImGuiCol_ResizeGrip] = HexToImVec4("#7F849CFF");
    style->Colors[ImGuiCol_ResizeGripHovered] = HexToImVec4("#89DCEB80");
    style->Colors[ImGuiCol_ResizeGripActive] = HexToImVec4("#B4BEFEFF");
    style->Colors[ImGuiCol_Tab] = HexToImVec4("#6C7086FF");
    style->Colors[ImGuiCol_TabHovered] = HexToImVec4("#89DCEB80");
    style->Colors[ImGuiCol_TabActive] = HexToImVec4("#B4BEFE80");
    style->Colors[ImGuiCol_TabUnfocused] = HexToImVec4("#7F849C80");
    style->Colors[ImGuiCol_TabUnfocusedActive] = HexToImVec4("#6C708680");
    style->Colors[ImGuiCol_DockingPreview] = HexToImVec4("#89DCEBFF");
    style->Colors[ImGuiCol_DockingEmptyBg] = HexToImVec4("#1E1E2EFF");
    style->Colors[ImGuiCol_PlotLines] = HexToImVec4("#A6ADC8FF");
    style->Colors[ImGuiCol_PlotLinesHovered] = HexToImVec4("#F5C2E780");
    style->Colors[ImGuiCol_PlotHistogram] = HexToImVec4("#F9E2AFFF");
    style->Colors[ImGuiCol_PlotHistogramHovered] = HexToImVec4("#FAB38780");
    style->Colors[ImGuiCol_TableHeaderBg] = HexToImVec4("#6C7086FF");
    style->Colors[ImGuiCol_TableBorderStrong] = HexToImVec4("#9399B2FF");
    style->Colors[ImGuiCol_TableBorderLight] = HexToImVec4("#7F849CFF");
    style->Colors[ImGuiCol_TableRowBg] = HexToImVec4("#181825FF");
    style->Colors[ImGuiCol_TableRowBgAlt] = HexToImVec4("#11111BFF");
    style->Colors[ImGuiCol_TextSelectedBg] = HexToImVec4("#585B7080");
    style->Colors[ImGuiCol_DragDropTarget] = HexToImVec4("#74C7ECFF");
    style->Colors[ImGuiCol_NavHighlight] = HexToImVec4("#B4BEFEFF");
    style->Colors[ImGuiCol_NavWindowingHighlight] = HexToImVec4("#6C7086FF");
    style->Colors[ImGuiCol_NavWindowingDimBg] = HexToImVec4("#CDD6F4FF");
    style->Colors[ImGuiCol_ModalWindowDimBg] = HexToImVec4("#BAC2DE80");
}
