export default abstract class FromState<T> {
  data: T;
  loading: boolean;
  error: Error | null;
  success: boolean;

  constructor(data: T) {
    this.data = data;
    this.loading = false;
    this.error = null;
    this.success = false;
  }

  reset(): void {
    this.loading = false;
    this.error = null;
    this.success = false;
  }

  async submit(): Promise<void> {
    this.loading = true;
    this.error = null;
    try {
      await this.post();
      this.success = true;
    } catch (error: any) {
      console.error("Error while submitting form", error);
      this.success = false;
      if (error instanceof Error)
        this.error = error;
      this.handleError();
    }
    this.loading = false;
  }

  abstract post(): Promise<void>;
  handleError(): Promise<void> | void { };
}
