#include <gmp.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int main(int argc, char *argv[]) {
  // Get the limit from the first argument
  if (argc != 2) {
    printf("Wrong input.\n");
    printf("Usage: howfast <limit>\n");
    return EXIT_FAILURE;
  }

  long int limit = strtol(argv[1], NULL, 10);

  // Setup GMP arithmetic library
  mpz_t a;
  mpz_t b;
  mpz_t c;

  mpz_init_set_ui(a, 1);
  mpz_init_set_ui(b, 0);
  mpz_init(c);

  // Start timer
  const clock_t start = clock();

  // Fibonacci calculation
  for (long int i = 0; i < limit; ++i) {
    mpz_add(c, a, b);
    mpz_set(a, b);
    mpz_set(b, c);
  }

  // End timer
  const clock_t end = clock();

  // Print the result
  printf("Fibonacci number %ld: ", limit);
  mpz_out_str(stdout, 10, b);
  printf("\n");

  // Clean up
  mpz_clear(a);
  mpz_clear(b);
  mpz_clear(c);

  // Print time
  double time_taken = ((double)(end - start)) / CLOCKS_PER_SEC;
  printf("Time: %f seconds\n", time_taken);
  return EXIT_SUCCESS;
}