#!/bin/bash
# This Bash script flattens a directory structure.
# It finds files in subdirectories, moves them to a base directory, and renames them to avoid conflicts. Finally, it removes any directories that become empty after the move.

# Function to move and rename files if necessary
move_and_rename() {
  local src_file="$1"
  local base_dir="$2"
  local filename=$(basename "$src_file")
  local dest_file="$base_dir/$filename"
  local counter=1

  # Rename the file if a file with the same name already exists
  while [ -e "$dest_file" ]; do
    dest_file="$base_dir/${filename%.*}_$counter.${filename##*.}"
    counter=$((counter + 1))
  done

  mv "$src_file" "$dest_file"
}

export -f move_and_rename

# Find and move files
find . -mindepth 2 -type f -exec bash -c 'move_and_rename "$0" "$PWD"' {} \;

# Remove empty directories
find . -type d -empty -delete
